;; Civil 3D Asset Auto-Loader
;; Automatically loads CUI and .NET assembly on startup

(defun LoadC3DAssets (/ cuiPath dllPath basePath userName)
  
  ;; Get username automatically
  (setq userName (getenv "USERNAME"))
  
  ;; Build paths dynamically
  (setq basePath (strcat "C:\\CoSD Support Files\\2025\\2025.0.3\\Lsp\\Local Save Resource Files\\"))
  (setq cuiPath (strcat basePath "Civil 3D Cloud.cuix"))
  (setq dllPath (strcat basePath "Local_Save_2025.dll"))
  
  ;; Print paths for debugging
  (princ "\n========================================")
  (princ (strcat "\nUsername detected: " userName))
  (princ (strcat "\nLooking for CUI at: " cuiPath))
  (princ (strcat "\nLooking for DLL at: " dllPath))
  (princ "\n========================================")
  
  ;; Check and load CUI
  (if (findfile cuiPath)
    (progn
      (princ "\n[OK] CUI file found!")
      (princ "\nLoading CUI...")
      (command "CUILOAD" cuiPath)
      (command)
      (princ "\n[OK] CUI loaded successfully.")
    )
    (princ "\n[ERROR] CUI file NOT FOUND!")
  )
  
  ;; Check and load DLL
  (if (findfile dllPath)
    (progn
      (princ "\n[OK] DLL file found!")
      (princ "\nLoading DLL...")
      (command "NETLOAD" dllPath)
      (command)
      (princ "\n[OK] DLL loaded successfully.")
    )
    (princ "\n[ERROR] DLL file NOT FOUND!")
  )
  
  (princ "\n========================================")
  (princ "\nAsset loading complete.")
  (princ)
)

;; Execute on load
(LoadC3DAssets)

(princ "")
(princ)